<?php
ob_start();

require_once 'plugins/dompdf/autoload.inc.php';
require_once 'config.php';

use Dompdf\Dompdf;
use Dompdf\Options;

// ==== Ambil data dari database ====
$q_puc = mysqli_query($con, "
    SELECT user.dept, user.username, pp_head.ppnote, pp_head.nopp, pp_head.tglpp, 
           pp_head.status_aprv, pp_head.status, pp_head.id, dept.dept AS dept2
    FROM pp_head 
    INNER JOIN user ON user.id = pp_head.user
    INNER JOIN dept ON dept.id = user.dept
    WHERE pp_head.id = '$_GET[id]'
");
$s_sql = mysqli_fetch_array($q_puc);

// ==== Ambil detail item ====
$q_puc2 = mysqli_query($con, "
    SELECT item.name, pp_detail.qty, pp_detail.unit, pp_detail.note
    FROM pp_detail 
    INNER JOIN item ON pp_detail.iditem = item.id 
    WHERE pp_detail.idpp = '$_GET[id]'
");

// ==== Konfigurasi DomPDF ====
$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

// ==== Path logo lokal ====
$logoPath = $_SERVER['DOCUMENT_ROOT'] . '/dist/img/logosrismall.png';
if (file_exists($logoPath)) {
    $logoBase64 = 'data:image/png;base64,' . base64_encode(file_get_contents($logoPath));
} else {
    $logoBase64 = '';
}

// ==== HTML untuk PDF ====
$html = '
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<style>
body {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 11px;
}

.header {
    display: flex;
    align-items: center;
    border-bottom: 1px solid #000;
    padding-bottom: 5px;
    margin-bottom: 10px;
}

.logo {
    width: 60px;
}

.title {
    font-weight: bold;
    font-size: 16px;
    margin-left: 15px;
}

.header-table {
    width: 100%;
    border-collapse: collapse;
}

.header-table td {
    border: none; /* ⬅️ hilangkan border tabel logo */
    vertical-align: middle;
}

.info {
    font-size: 14px;
    margin-top: 3px;
}

.date {
    text-align: right;
    font-size: 14px;
}

.main-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
    border: none; /* hilangkan border tabel */
}

.main-table th, .main-table td {
    border: none !important; /* pastikan tidak ada garis */
    padding: 4px;
    text-align: left;
}

.main-table th {
    background: none; /* hapus warna latar header */
    font-size: 14px;
    font-weight: bold;
}

.main-table td {
    font-size: 14px;
}

.notes {
    margin-top: 10px;
    font-size: 14px;
}

.footer {
    margin-top: 25px;
}

.sign-table {
    width: 100%;
    border-collapse: collapse;
    text-align: center;
    margin-top: 20px;
}

.sign-table td {
    border: none;
    font-size: 14px;
    padding-bottom: 25px;
}

.sign-line {
    border-top: 1px solid #000;
    width: 100px;
    margin: 0 auto;
}

.sop {
    font-size: 9px;
    text-align: right;
    margin-top: 15px;
}
</style>
</head>
<body>

<br><br>
<table class="main-table" >
<tr></tr>
<td style="width:10%;"></td>
<td>'.$s_sql['nopp'].'</td>
<td style="width:20%;"></td>
<td>'.$s_sql['dept2'].'</td>
<td style="width:20%;"></td>
<td>'.date("Y-m-d").'</td>
</table>



<br>
<table class="main-table" >

<tbody>';
while($row = mysqli_fetch_array($q_puc2)) {
    $html .= '
    <tr>
        <td>'.$row['name'].'</td>
        <td style="width:10%;"></td>
		<td style="text-align: center;">'.$row['qty'].'</td>
        <td>&nbsp;&nbsp;&nbsp;'.$row['unit'].'</td>
        <td>'.$row['note'].'</td>
    </tr>';
}
$html .= '
</tbody>
</table>

<div class="notes">
   
</div>

<div class="footer">

</div>

<div class="sop"></div>

</body>
</html>
';

// ==== Generate PDF ====
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

ob_end_clean();
$dompdf->stream("PR_".$s_sql['nopp'].".pdf", ["Attachment" => false]);
exit;
?>
