<?php
ob_start();

require_once 'plugins/dompdf/autoload.inc.php';
require_once 'config.php';

use Dompdf\Dompdf;
use Dompdf\Options;

// ==== Ambil data dari database ====
$q_puc = mysqli_query($con, "
    SELECT  dept.dept AS dept2,npb_pp.nonpb,SUPPLIER.NAMA_PERUSAHAAN,po_pp.nopo
    FROM npb_pp 
	inner join pp_detail on pp_detail.id=npb_pp.id_pp_detail
    inner join pp_head on pp_head.id=pp_detail.idpp
	INNER JOIN user ON user.id = pp_head.user
    INNER JOIN dept ON dept.id = user.dept
	inner join po_pp_detail on po_pp_detail.id=npb_pp.id_po_detail
	inner join po_pp on po_pp.id=po_pp_detail.idpo
	inner join SUPPLIER on SUPPLIER.id=po_pp.idsupplier
    WHERE npb_pp.nonpb = '$_GET[id]' limit 1
");
$s_sql = mysqli_fetch_array($q_puc);

// ==== Ambil detail item ====
$q_puc2 = mysqli_query($con, "
   SELECT dept.dept as dept2,item.name,npb_pp.qty,po_pp_detail.price,pp_detail.unit
FROM `npb_pp` inner JOIN pp_detail on pp_detail.id=npb_pp.id_pp_detail
inner join po_pp_detail on po_pp_detail.id=npb_pp.id_po_detail
inner join pp_head on pp_head.id=pp_detail.idpp
inner join po_pp on po_pp.id=po_pp_detail.idpo
inner join user on user.id=pp_head.user
inner join dept on dept.id=user.dept
inner join item on item.id=pp_detail.iditem
inner join SUPPLIER on SUPPLIER.id=po_pp.idsupplier
WHERE npb_pp.status_live='0' and 
     npb_pp.nonpb = '$_GET[id]'
");

// ==== Konfigurasi DomPDF ====
$options = new Options();
$options->set('isHtml5ParserEnabled', true);	
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

// ==== Path logo lokal ====
$logoPath = $_SERVER['DOCUMENT_ROOT'] . '/dist/img/logosrismall.png';
if (file_exists($logoPath)) {
    $logoBase64 = 'data:image/png;base64,' . base64_encode(file_get_contents($logoPath));
} else {
    $logoBase64 = '';
}

// ==== HTML untuk PDF ====
$html = '
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<style>
body {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 11px;
}

.header {
    display: flex;
    align-items: center;
    border-bottom: 1px solid #000;
    padding-bottom: 5px;
    margin-bottom: 10px;
}

.logo {
    width: 60px;
}

.title {
    font-weight: bold;
    font-size: 16px;
    margin-left: 15px;
}

.header-table {
    width: 100%;
    border-collapse: collapse;
}

.header-table td {
    border: none; /* ⬅️ hilangkan border tabel logo */
    vertical-align: middle;
}

.info {
    font-size: 10px;
    margin-top: 3px;
}

.date {
    text-align: right;
    font-size: 10px;
}

.main-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
}

.main-table th, .main-table td {
    border: 1px solid #000;
    padding: 4px;
    text-align: left;
}

.main-table th {
    background: #f0f0f0;
    font-size: 10px;
}

.main-table td {
    font-size: 10px;
}

.notes {
    margin-top: 10px;
    font-size: 10px;
}

.footer {
    margin-top: 25px;
}

.sign-table {
    width: 100%;
    border-collapse: collapse;
    text-align: center;
    margin-top: 20px;
}

.sign-table td {
    border: none;
    font-size: 10px;
    padding-bottom: 25px;
}

.sign-line {
    border-top: 1px solid #000;
    width: 100px;
    margin: 0 auto;
}

.sop {
    font-size: 9px;
    text-align: right;
    margin-top: 15px;
}

.sign-border-table {
    width: 100%;
    border-collapse: collapse;
    text-align: center;
    margin-top: 20px;
}

.sign-border-table td {
    border: 1px solid #000;
    font-size: 10px;
    padding: 10px;
    height: 20px; /* biar agak tinggi */
	  text-align: left;       /* rata kiri */
    vertical-align: top;    /* rata atas */
}
</style>
</head>
<body>

<div class="header">
<table class="header-table">
<tr>
    <td width="70"><img src="'.$logoBase64.'" class="logo"></td>
    <td><div class="title">LETTER OF GOODS RECEIVAL</div></td>
</tr>
</table>
</div>

<table class="header-table">
<tr>
    <td >Dept: '.$s_sql['dept2'].'</td>
    <td>No: '.$s_sql['nonpb'].'</div></td>
	<td >Supplier: '.$s_sql['NAMA_PERUSAHAAN'].'</td>
    <td>No. PO: '.$s_sql['nopo'].'</td>
</tr>
</table>



<table class="main-table">
<thead>
<tr>
	<th>NO</th>
    <th>ITEM DESCRIPTION</th>
    <th>QTY</th>
    <th>UNIT</th>
    <th>UNIT PRICE</th>
</tr>
</thead>
<tbody>';
$kk=1;
while($row = mysqli_fetch_array($q_puc2)) {
    $html .= '
    <tr>
	<td>'.$k.'</td>
        <td>'.$row['name'].'</td>
        <td>'.$row['qty'].'</td>
        <td>'.$row['unit'].'</td>
        <td>'.$row['price'].'</td>
		
    </tr>';
	$k+=1;
}
$k=" SELECT dept.dept as dept2,item.name,npb_pp.qty,po_pp_detail.price
FROM `npb_pp` inner JOIN pp_detail on pp_detail.id=npb_pp.id_pp_detail
inner join po_pp_detail on po_pp_detail.id=npb_pp.id_po_detail
inner join pp_head on pp_head.id=pp_detail.idpp
inner join po_pp on po_pp.id=po_pp_detail.idpo
inner join user on user.id=pp_head.user
inner join dept on dept.id=user.dept
inner join item on item.id=pp_detail.iditem
inner join SUPPLIER on SUPPLIER.id=po_pp.idsupplier
WHERE npb_pp.status_live='0' and 
     npb_pp.nonpb = '$_GET[id]'";
$html .= '
</tbody>
</table>
';
//$html=$html.$k;
$html .= '



<table class="sign-border-table" >
<tr>
    <td>Received By,</td>
    <td>Date,</td>
    <td>Finance Dept,</td>
</tr>
</table>


<div class="sop">SOP/PU/002/F001/R.00</div>

</body>
</html>
';

// ==== Generate PDF ====
$dompdf->loadHtml($html);
$dompdf->setPaper([0, 0, 595, 420], 'portrait');
$dompdf->render();

ob_end_clean();
$dompdf->stream("NPB_".$s_sql['nopp'].".pdf", ["Attachment" => false]);
exit;
?>
